/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.launch;

import catserver.server.utils.LanguageUtils;
import catserver.server.utils.Md5Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LibrariesManager {
    private static final List<String> librariesSources = new ArrayList<String>();
    public static final File serverJarDir = LibrariesManager.findJarDir();
    public static final File librariesDir = new File(serverJarDir, "libraries");
    public static final String sparkPluginFileName = "spark-1.8.19-bukkit.jar";
    public static final String sparkPluginMD5 = "ab5e7e1cd1bcd7cc910c2b7a59e7b7e5";

    public static void checkLibraries() {
        InputStream listStream;
        if (!librariesDir.exists()) {
            librariesDir.mkdir();
        }
        if ((listStream = ClassLoader.getSystemResourceAsStream("libraries.info")) == null) {
            return;
        }
        LibrariesManager.updateMCServerJar(serverJarDir, librariesDir);
        HashMap<File, String> librariesNeedDownload = new HashMap<File, String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(listStream));){
            File sparkPluginFile;
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                String[] args = str.split("\\|");
                if (args.length != 2) continue;
                String key = args[0];
                String value = args[1];
                try {
                    File file = new File(serverJarDir, key);
                    if (file.exists() && Md5Utils.getFileMD5String(file).equals(value)) continue;
                    librariesNeedDownload.put(file, value);
                }
                catch (IOException e) {
                    System.out.println(e.toString());
                }
            }
            if (!(!Boolean.parseBoolean(System.getProperty("catserver.spark.enable", "true")) || (sparkPluginFile = new File(librariesDir, sparkPluginFileName)).exists() && Md5Utils.getFileMD5String(sparkPluginFile).equals(sparkPluginMD5))) {
                librariesNeedDownload.put(sparkPluginFile, sparkPluginMD5);
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (librariesNeedDownload.size() > 0) {
            System.out.println(LanguageUtils.I18nToString("launch.lib_missing"));
            LibrariesManager.loadDownloadSources();
            for (Map.Entry entry : librariesNeedDownload.entrySet()) {
                LibrariesManager.tryDownload((File)entry.getKey(), (String)entry.getValue());
            }
            System.out.println(LanguageUtils.I18nToString("launch.lib_download_completed"));
        }
    }

    private static File findJarDir() {
        try {
            URL jarUrl = LibrariesManager.class.getProtectionDomain().getCodeSource().getLocation();
            File jarFile = new File(URLDecoder.decode(jarUrl.getPath(), "UTF-8"));
            if (jarFile.isFile()) {
                return jarFile.getParentFile().getAbsoluteFile();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new File(".");
    }

    private static void loadDownloadSources() {
        try {
            String str = LibrariesManager.sendRequest("https://catserver.moe/api/libraries_sources/");
            for (String s : str.split("\\|")) {
                if (!s.startsWith("http://") && !s.startsWith("https://")) continue;
                librariesSources.add(s);
            }
        }
        catch (IOException e) {
            System.out.println(e.toString());
        }
        if (librariesSources.size() == 0) {
            librariesSources.add("http://sv.catserver.moe:8001/dl/");
            librariesSources.add("http://sv2.catserver.moe:8001/dl/");
            librariesSources.add("http://cdn.catserver.moe/dl/");
        }
    }

    private static void tryDownload(File file, String md5) {
        Iterator<String> iterator = librariesSources.iterator();
        while (iterator.hasNext()) {
            String downloadUrl = iterator.next() + file.getName();
            try {
                new Downloader(downloadUrl, file);
                if (!file.exists() || md5 != null && !Md5Utils.getFileMD5String(file).equals(md5)) {
                    System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_failure_check"), file.getName(), downloadUrl));
                }
                return;
            }
            catch (IOException e) {
                System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_failure_download"), e.toString(), downloadUrl));
                if (!(e instanceof ConnectException) && !(e instanceof SocketTimeoutException)) continue;
                iterator.remove();
            }
        }
    }

    private static String sendRequest(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("Connection", "Close");
        connection.connect();
        String result = "";
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        return result;
    }

    private static void updateMCServerJar(File currentJarPath, File librariesPath) {
        File oldMCServerJar = new File(currentJarPath, "minecraft_server.1.12.2.jar");
        File targetMCServerJar = new File(librariesPath, "minecraft_server.1.12.2.jar");
        try {
            if (oldMCServerJar.exists()) {
                if (!targetMCServerJar.exists()) {
                    oldMCServerJar.renameTo(targetMCServerJar);
                } else {
                    oldMCServerJar.delete();
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    static class Downloader {
        public Downloader(String downloadUrl, File saveFile) throws IOException {
            URL url = new URL(downloadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(8000);
            connection.setRequestMethod("GET");
            System.out.println(String.format(LanguageUtils.I18nToString("launch.lib_downloading"), saveFile.getName(), this.getSize(connection.getContentLengthLong())));
            ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(saveFile);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            rbc.close();
            fos.close();
            connection.disconnect();
        }

        private String getSize(long size) {
            if (size >= 0x100000L) {
                return (float)size / 1048576.0f + " MB";
            }
            if (size >= 1024L) {
                return (float)size / 1024.0f + " KB";
            }
            return size + " B";
        }
    }
}

